// -----------------------------------------------------------------------------------------
//                      M A T E R I A L S
//------------------------------------------------------------------------------------------

#declare C_black =          color rgb<0,0,0>  ;
#declare C_tan          =   color red 0.85 green 0.66 blue 0.5; 
#declare C_horizon_blue =   color red .82 green 1 blue .98; 

#declare F_satin =
finish {
    ambient .2
    diffuse 1   
    phong .5
    phong_size 40  
}

#declare F_concrete_smooth =
finish {
    ambient .3
    diffuse 1   
    phong 1
    phong_size 60 
    reflection {.01, .5 fresnel} 
}    

#declare F_plastic =
finish {
    ambient .2
    diffuse 1   
    phong .7
    phong_size 80  
}

#declare F_soft_plastic =
finish {
    ambient .3
    diffuse 1   
    phong 1
    phong_size 20 
    reflection {.001, .1 fresnel} 
}                      


#declare N_granite_A =
normal { 
    pigment_pattern{ 
        granite 
        turbulence 0.2
        colour_map {[0.00, rgb 1] 
                    [0.5, rgb 1]
                    [0.7, rgb 0]
                    [0.9, rgb 0]
                    [1.00, rgb 1]
                    } 
     } 
     bump_size .02
} 


#declare M_plastic_black =
material {
    texture {
       pigment { C_black }
       finish  { F_plastic }
   }
}


#declare M_old_wall = 
material{ 
    texture{ 
        pigment {C_tan} 
        finish {F_soft_plastic}
        normal {N_granite_A scale <20,20,20> }
        } 
}

#declare M_old_wall_light_tan = 
material{ 
    texture{ 
        pigment {C_tan*2} 
        finish {F_soft_plastic}
        normal {N_granite_A scale <20,20,20> }
        } 
}


#declare M_old_trim = 
material{ 
    texture{ 
        pigment {C_horizon_blue *.2} 
        finish {F_soft_plastic}
        normal {N_granite_A scale <10,7,10> }
        } 
}


